# local_secrets/payment/urls.py

from django.urls import path, include
from rest_framework.routers import DefaultRouter
from django.conf import settings
#from .webhooks import UnifiedWebhookView
from .views import (
    PaymentViewSet, 
    AutomaticBillingViewSet, 
    TestPaymentInterface, 
    TestPaymentProcessView,
    PaymentCreateView,
    PaymentSuccessView,
    PaymentFailureView, 
    VendorPaymentListView,
    VendorPaymentDetailView
)

app_name = 'payment'

# Create a router for viewsets
router = DefaultRouter()
router.register(r'payments', PaymentViewSet, basename='payment')
router.register(r'automatic-billing', AutomaticBillingViewSet, basename='automatic-billing')

# Django-payments specific patterns
payment_core_patterns = [
    path('', include('payments.urls')),  # Core django-payments URLs
]

# Vendor payment specific patterns
vendor_payment_patterns = [
    path('payments/', VendorPaymentListView.as_view(), name='vendor-payment-list'),
    path('payments/<int:pk>/', VendorPaymentDetailView.as_view(), name='vendor-payment-detail'),
    path('create/', PaymentCreateView.as_view(), name='payment_create'),
    path('success/<int:payment_id>/', PaymentSuccessView.as_view(), name='payment_success'),
    path('failure/<int:payment_id>/', PaymentFailureView.as_view(), name='payment_failure'),
]

# Payment method patterns
payment_method_patterns = [
    path('payment-methods/', 
         PaymentViewSet.as_view({
             'get': 'list_payment_methods',
             'post': 'add_payment_method'
         }), 
         name='payment-methods'),
    
    path('payment-methods/<int:pk>/', 
         PaymentViewSet.as_view({
             'delete': 'remove_payment_method',
             'put': 'update_payment_method'
         }), 
         name='payment-method-detail'),
]

# Webhook patterns
webhook_patterns = [
    path('webhooks/<str:gateway>/', 
         UnifiedWebhookView.as_view(), 
         name='unified-payment-webhook'),
]

# Test interface patterns - only included in debug mode
test_patterns = [
    path('test/', TestPaymentInterface.as_view(), name='test_interface'),
    path('test/process/', TestPaymentProcessView.as_view(), name='test_process'),
] if settings.DEBUG else []

# Combine all URL patterns
urlpatterns = (
    payment_core_patterns + 
    vendor_payment_patterns + 
    payment_method_patterns + 
    webhook_patterns + 
    test_patterns + 
    router.urls
)

